//
//  MCPDatabaseExtensionPlugin.h
//  MCFoundation
//
//  Created by Alykhan Jetha on Fri Jun 06 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPDatabaseConnection;


typedef enum _MCDBExtensionSchemaValidation {
    MCDBExtensionSchemaValid				= 1,
    MCDBExtensionSchemaTooLow				= -1,
    MCDBExtensionSchemaTooHigh				= -2
} MCDBExtensionSchemaValidation;



@interface MCPDatabaseExtensionPlugin : NSObject {

}

- (NSString *)name;

- (MCDBExtensionSchemaValidation)isDatabaseConnectionValid:(MCPDatabaseConnection *)conn;

- (NSArray *)handleSchemaForDatabaseConnection:(MCPDatabaseConnection *)conn;

- (BOOL)equalSchemaForConnection:(MCPDatabaseConnection *)first andConnection:(MCPDatabaseConnection *)second;

- (void)handleReplicationEntities:(NSMutableArray *)entities;


@end
